/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.layout;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.github.fabricators_of_create.porting_lib.entity.events.OnDatapackSyncCallback;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3324;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.layout.LayoutIcon;
import slimeknights.tconstruct.library.tools.layout.StationSlotLayout;
import slimeknights.tconstruct.library.tools.layout.UpdateTinkerSlotLayoutsPacket;

public class StationSlotLayoutLoader
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final Logger log = LogManager.getLogger(StationSlotLayoutLoader.class);
    public static final String FOLDER = "tinkering/station_layouts";
    public static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(class_1856.class, (Object)new IngredientSerializer()).registerTypeHierarchyAdapter(LayoutIcon.class, (Object)LayoutIcon.SERIALIZER).registerTypeAdapter(Pattern.class, (Object)Pattern.SERIALIZER).setPrettyPrinting().disableHtmlEscaping().create();
    private static final StationSlotLayoutLoader INSTANCE = new StationSlotLayoutLoader();
    private Map<class_2960, StationSlotLayout> layoutMap = Collections.emptyMap();
    private final List<class_2960> requiredLayouts = new ArrayList<class_2960>();
    private List<StationSlotLayout> sortedSlots = Collections.emptyList();

    private StationSlotLayoutLoader() {
        super(GSON, FOLDER);
    }

    public void setSlots(Collection<StationSlotLayout> slots) {
        this.setSlots(slots.stream().collect(Collectors.toMap(StationSlotLayout::getName, Function.identity())));
    }

    private void setSlots(Map<class_2960, StationSlotLayout> map) {
        this.layoutMap = map;
        this.sortedSlots = map.values().stream().filter(layout -> !layout.isMain()).sorted(Comparator.comparingInt(StationSlotLayout::getSortIndex)).collect(Collectors.toList());
    }

    protected void apply(Map<class_2960, JsonElement> splashList, class_3300 resourceManager, class_3695 profiler) {
        long time = System.nanoTime();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<class_2960, JsonElement> entry : splashList.entrySet()) {
            class_2960 key = entry.getKey();
            JsonElement value = entry.getValue();
            try {
                JsonObject object = class_3518.method_15295((JsonElement)value, (String)"station_layout");
                if (object.entrySet().isEmpty()) continue;
                StationSlotLayout layout = (StationSlotLayout)GSON.fromJson((JsonElement)object, StationSlotLayout.class);
                int size = layout.getInputSlots().size() + (layout.getToolSlot().isHidden() ? 0 : 1);
                if (size < 2) {
                    throw new JsonParseException("Too few slots for layout " + key + ", must have at least 2");
                }
                layout.setName(key);
                builder.put((Object)key, (Object)layout);
            }
            catch (Exception e) {
                log.error("Failed to load station slot layout for name {}", (Object)key, (Object)e);
            }
        }
        this.setSlots((Map<class_2960, StationSlotLayout>)builder.build());
        log.info("Loaded {} station slot layouts in {} ms", (Object)this.layoutMap.size(), (Object)Float.valueOf((float)(System.nanoTime() - time) / 1000000.0f));
        List missing = this.requiredLayouts.stream().filter(name -> !this.layoutMap.containsKey(name)).map(class_2960::toString).collect(Collectors.toList());
        if (!missing.isEmpty()) {
            log.error("Failed to load the following required layouts: {}", (Object)String.join((CharSequence)", ", missing));
        }
    }

    public StationSlotLayout get(class_2960 name) {
        return this.layoutMap.getOrDefault(name, StationSlotLayout.EMPTY);
    }

    public void registerRequiredLayout(class_2960 name) {
        this.requiredLayouts.add(name);
    }

    private void onDatapackSync(class_3324 playerList, @Nullable class_3222 player) {
        UpdateTinkerSlotLayoutsPacket packet = new UpdateTinkerSlotLayoutsPacket(this.layoutMap.values());
        TinkerNetwork.getInstance().sendToPlayerList(player, playerList, packet);
    }

    private void addDataPackListeners() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)this);
    }

    public static StationSlotLayoutLoader getInstance() {
        return INSTANCE;
    }

    public static void init() {
        INSTANCE.addDataPackListeners();
        OnDatapackSyncCallback.EVENT.register(INSTANCE::onDatapackSync);
    }

    public class_2960 getFabricId() {
        return TConstruct.getResource("station_slot_layout_loader");
    }

    public List<StationSlotLayout> getSortedSlots() {
        return this.sortedSlots;
    }

    private static class IngredientSerializer
    implements JsonSerializer<class_1856>,
    JsonDeserializer<class_1856> {
        private IngredientSerializer() {
        }

        public class_1856 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return class_1856.method_52177((JsonElement)json);
        }

        public JsonElement serialize(class_1856 ingredient, Type typeOfSrc, JsonSerializationContext context) {
            return ingredient.method_8089();
        }
    }
}

